/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IAnimation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class SprintAnimation
implements IAnimation {
    private final PlayerEntity player;
    private final int length;
    private int sprintTime;
    private float progress;
    private float progressOld;
    private float progressInterpolated;

    public SprintAnimation(PlayerEntity player) {
        this.player = player;
        this.length = 10;
    }

    @Override
    public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        if (stage == AnimationStage.ITEM_AND_HANDS) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-20.0f * this.progressInterpolated));
        } else if (stage == AnimationStage.LEFT_HAND || stage == ModAnimations.DUAL_WIELD_ITEM) {
            matrixStack.func_227861_a_(0.0, (double)(-0.5f * this.progressInterpolated), (double)(0.8f * this.progressInterpolated));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(40.0f * this.progressInterpolated));
        }
    }

    @Override
    public void gameTick() {
        int i = this.player.func_70051_ag() ? 1 : -1;
        this.sprintTime = MathHelper.func_76125_a((int)(this.sprintTime + i), (int)0, (int)this.length);
        this.progressOld = this.progress;
        this.progress = this.getProgress();
    }

    @Override
    public void renderTick(float deltaRenderTime) {
        this.progressInterpolated = AnimationUtils.linearInterpolate(this.progress, this.progressOld, deltaRenderTime);
    }

    @Override
    public boolean hasFinished() {
        return !this.player.func_70051_ag() && this.progressInterpolated <= 0.0f;
    }

    private float getProgress() {
        return (float)this.sprintTime / (float)this.length;
    }
}

